from codeable_detectors.python.pythonDetectors import PythonImportLink
from codeable_detectors.utils import extend_lists_in_keyword_args


class PythonOpenTracingLink(PythonImportLink):
    def __init__(self):
        super().__init__("opentracing")

    def detect_in_context(self, ctx, **kwargs):
        extend_lists_in_keyword_args(kwargs, "link_types", "http2")
        extend_lists_in_keyword_args(kwargs, "technology_types", "instana")
        return super().detect_in_context(ctx, **kwargs)
